#include <stdio.h>
#include <string.h>
#include <libpq-fe.h>

#define TIRETA   "====================================="
#define DEFTABLE "hora"

int main(int argc, char *argv[]){
   char *table = (argc > 1) ? argv[1] : DEFTABLE;

   PGconn *conn = PQsetdbLogin(NULL, NULL, NULL, NULL, "ivo", NULL, NULL);
/*                     host  port              db     user  pass  */
   if (PQstatus(conn) == CONNECTION_BAD){
      PQfinish(conn);
      printf("Can;t connect to the server\n");
      return 1;
   }

   char sql[100]; 
   strcpy(sql, "select * from ");
   strcat(sql, table);

   PGresult *res=PQexec(conn, sql);
   
   if (PQresultStatus(res) == PGRES_TUPLES_OK){
      long int rec = PQntuples(res);
      long int col = PQnfields(res);

      printf("Database matrix: %ldx%ld\n", rec, col);

      printf(TIRETA"\n");

      for (long int j=0; j < col; j++)
         printf("%s\t",PQfname(res,j));

      printf("\n"TIRETA"\n");

      for (long int i=0; i < rec; i++){
          for (long int j=0; j < col; j++)
             printf("%s\t", PQgetvalue(res, i, j));

          printf("\n"); 
      }
      printf(TIRETA"\n");

      PQclear(res);
   }else
       printf("SQL return no data\n");

   PQfinish(conn);
   return 0;
}
