#include "mad.h"
#include "prop.h"

/*
     Macro Replacer - replace 'macroses' into strings
   by Nikolay Mijaylov  (c) 1996(?), 1998, 1999, Sofia

   first realisation - Turbo Pascal, non objects

   object tree:
   
   AbstractMacroReplacer(8)=+-----MacroReplacer
*/

class AbstractMacroReplacer{
protected:
   StringBuffer *sb;
   
   char          bdelim;
   char          edelim;
   
   short int     logic_status;
   
   void initLogic();
   char logic(char x);
   
public:
   AbstractMacroReplacer(char bdelim = '[', char edelim = ']'):
                                sb(new StringBuffer()),
                                bdelim(bdelim),
                                edelim(edelim){};
   virtual ~AbstractMacroReplacer(){
      delete(sb);
   };

   const char *replace(const char *source);

   virtual const char *replaceField(const char *) = 0;
};

class MacroReplacer:public AbstractMacroReplacer{
protected:
   Properties *pr;
public:
   MacroReplacer(Properties *pr, char bdelim = '[', char edelim = ']'):
                                AbstractMacroReplacer(bdelim, edelim),
                                pr(pr){
   };
   const char *replaceField(const char *field);
};
